/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.mss;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BladeGraphic {
    private GenModel mssModel;
    private GenModel baseBladeResetModel;
    private GenModel pcmciaBladeModel;
    private GenModel systemModel;
    private JdmBrowser mssJdmBrowser;
    private Vector modelList;
    private Vector remoteStatusList;
    private Vector proxyStatusList;
    private Vector pcmcia_Info = new Vector();
    private boolean ssBlade = false;
    protected static final String PropertiesFile = "properties/Mss.txt";
    private static final String layoutKey = "blade.layout.scheme";
    private static final String fractKey = "blade.layout.fractions";
    private static final String bundleName = "ibm.nways.mss.Resources";
    private static final String cookiePath = "ibm.nways.mss.WCDefault";
    private static final int RASID = 19;
    private static final int RASSUB = 26;
    static final int startingX = 20;

    protected BladeGraphic(JdmBrowser jdmBrowser) {
        this.mssJdmBrowser = jdmBrowser;
        this.modelList = new Vector();
        this.remoteStatusList = new Vector();
        this.proxyStatusList = new Vector();
    }

    protected GraphicPanel getGraphicPanel() {
        GraphicContainer graphicContainer;
        block27: {
            WidgetCookie widgetCookie;
            String string;
            ModelInfo modelInfo;
            CookieTray cookieTray;
            block26: {
                Properties properties;
                Serializable serializable;
                graphicContainer = new GraphicContainer();
                try {
                    serializable = new URL(this.mssJdmBrowser.getDocumentBase(), PropertiesFile);
                    if (RAS.isEnabled(19, 26)) {
                        RAS.trace(19, 26, this, "getGraphicPanel()", "DocumentBase = " + this.mssJdmBrowser.getDocumentBase());
                    }
                    properties = new Properties();
                    properties.load(((URL)serializable).openStream());
                }
                catch (Exception exception) {
                    properties = null;
                    RAS.logError(19, 26, this, "getGraphicPanel()", "EXCEPTION_GETTING_PROPERTIES", (Object)(String.valueOf(this.mssJdmBrowser.getDocumentBase()) + PropertiesFile));
                }
                JdmLayout jdmLayout = (JdmLayout)this.mssJdmBrowser.getLayout();
                if (properties != null) {
                    serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
                    if (RAS.isEnabled(19, 26)) {
                        RAS.trace(19, 26, this, "getGraphicPanel()", "Layout = " + serializable);
                    }
                    int n = (Integer)serializable;
                    jdmLayout.setScheme(n);
                    String string2 = (String)((Hashtable)properties).get(fractKey);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    float[] fArray = new float[stringTokenizer.countTokens()];
                    boolean bl = true;
                    int n2 = 0;
                    while (n2 < fArray.length && stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        try {
                            fArray[n2] = Float.valueOf(string3).floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            RAS.logError(19, 26, this, "getGraphicPanel()", "EXCEPTION_CALCULATING_FRACTIONS", (Object)numberFormatException);
                            bl = false;
                        }
                        ++n2;
                    }
                    if (bl) {
                        jdmLayout.setFracts(fArray);
                    }
                } else {
                    int n = 1;
                    jdmLayout.setScheme(n);
                }
                this.getBladeInfo();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleName);
                cookieTray = !this.ssBlade ? new CookieTray(bundleName, new Point(20, 0), "Mssblade.gif", "", this.mssJdmBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel") : new CookieTray(bundleName, new Point(20, 0), "ssmssblade.gif", "", this.mssJdmBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel");
                graphicContainer.add((GraphicContainer)cookieTray);
                serializable = new GraphicHelp((BrowserApplet)this.mssJdmBrowser, new Point(0, 0), new HelpRef((Object)this));
                graphicContainer.add((GraphicComponent)serializable);
                WidgetCookie widgetCookie2 = new WidgetCookie("Rs232bld", bundleName, null, cookiePath, null, this.mssJdmBrowser, 22);
                if (!this.ssBlade) {
                    widgetCookie2.setLocation(new Point(77, 494));
                } else {
                    widgetCookie2.setLocation(new Point(18, 484));
                }
                cookieTray.AddWidget(widgetCookie2);
                WidgetCookie widgetCookie3 = new WidgetCookie("single1", bundleName, null, cookiePath, this.baseBladeResetModel, this.mssJdmBrowser, 20, "ibm.nways.mss.ResetBladePanel");
                if (!this.ssBlade) {
                    widgetCookie3.setLocation(new Point(68, 445));
                } else {
                    widgetCookie3.setLocation(new Point(23, 446));
                }
                cookieTray.AddWidget(widgetCookie3);
                try {
                    this.pcmcia_Info = this.pcmciaBladeModel.getRestOfInfo("Config", "default", null, null);
                }
                catch (Exception exception) {
                    RAS.logException(19, 26, this, "getGraphicPanel()", exception);
                }
                try {
                    modelInfo = (ModelInfo)this.pcmcia_Info.elementAt(1);
                    string = modelInfo.get("Config.Mss8260PCAdapType").toString();
                    if (RAS.isEnabled(19, 26)) {
                        RAS.trace(19, 26, this, "getGraphicPanel()", "Blade pcmica slot #1 type = " + string);
                    }
                    if ((widgetCookie = this.getPcmciaImage(string, 1, modelInfo)) != null) {
                        if (RAS.isEnabled(19, 26)) {
                            RAS.trace(19, 26, this, "getGraphicPanel()", "Setting Status PCMCIA Blade #1");
                        }
                        cookieTray.AddWidget(widgetCookie);
                    }
                }
                catch (Exception exception) {
                    if (!RAS.isEnabled(19, 26)) break block26;
                    RAS.trace(19, 26, this, "getGraphicPanel()", "No PCMCIA in slot 1");
                }
            }
            try {
                modelInfo = (ModelInfo)this.pcmcia_Info.elementAt(0);
                string = modelInfo.get("Config.Mss8260PCAdapType").toString();
                if (RAS.isEnabled(19, 26)) {
                    RAS.trace(19, 26, this, "getGraphicPanel()", "Blade pcmica slot #2 type = " + string);
                }
                if ((widgetCookie = this.getPcmciaImage(string, 2, modelInfo)) != null) {
                    if (RAS.isEnabled(19, 26)) {
                        RAS.trace(19, 26, this, "getGraphicPanel()", "Setting Status PCMCIA Blade #2");
                    }
                    cookieTray.AddWidget(widgetCookie);
                }
            }
            catch (Exception exception) {
                if (!RAS.isEnabled(19, 26)) break block27;
                RAS.logException(19, 26, this, "getGraphicPanel()", exception);
            }
        }
        GraphicPanel graphicPanel = new GraphicPanel((GraphicHandler)this.mssJdmBrowser, (Component)graphicContainer);
        return graphicPanel;
    }

    private void getBladeInfo() {
        block13: {
            block12: {
                block11: {
                    if (this.pcmciaBladeModel == null) {
                        try {
                            this.pcmciaBladeModel = (GenModel)this.mssModel.getComponent("PcmciaBlade");
                        }
                        catch (Exception exception) {
                            if (!RAS.isEnabled(19, 26)) break block11;
                            RAS.trace(19, 26, this, "getBladeInfo()", "Exception getting Graphic Blade");
                        }
                    }
                }
                if (this.baseBladeResetModel == null) {
                    try {
                        this.baseBladeResetModel = (GenModel)this.mssModel.getComponent("BaseBladeReset");
                        if (RAS.isEnabled(19, 26)) {
                            RAS.trace(19, 26, this, "getBladeInfo()", "Got Graphic base Blade Reset");
                        }
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 26, this, "getBladeInfo()", exception);
                        if (!RAS.isEnabled(19, 26)) break block12;
                        RAS.trace(19, 26, this, "getBladeInfo()", "Exception getting Graphic Blade Reset");
                    }
                }
            }
            if (this.systemModel == null) {
                try {
                    this.systemModel = (GenModel)this.mssModel.getComponent("System");
                    if (RAS.isEnabled(19, 26)) {
                        RAS.trace(19, 26, this, "getBladeInfo()", "Got Graphic system model");
                        return;
                    }
                }
                catch (Exception exception) {
                    RAS.logException(19, 26, this, "getBladeInfo()", exception);
                    if (!RAS.isEnabled(19, 26)) break block13;
                    RAS.trace(19, 26, this, "getBladeInfo()", "Exception getting Graphic System Model");
                    return;
                }
            }
        }
    }

    private WidgetCookie getPcmciaImage(String string, int n, ModelInfo modelInfo) {
        WidgetCookie widgetCookie;
        String string2;
        Integer n2 = new Integer(string);
        int n3 = n2;
        Point point = new Point(0, 0);
        switch (n3) {
            case 2: {
                string2 = "hdriveBld";
                point = this.hdriveLocationInBlade(n, this.ssBlade);
                break;
            }
            case 3: {
                string2 = "modemBld";
                point = this.pcmciaLocationInBlade(n, this.ssBlade);
                break;
            }
            case 5: {
                string2 = "flashBld";
                point = this.pcmciaLocationInBlade(n, this.ssBlade);
                break;
            }
            case 1: {
                string2 = "PcmciaBld";
                point = this.pcmciaLocationInBlade(n, this.ssBlade);
                break;
            }
            case 4: {
                string2 = null;
                if (!RAS.isEnabled(19, 26)) break;
                RAS.trace(19, 26, this, "getPcmciaImage()", "PCMCIA Not Present");
                break;
            }
            default: {
                string2 = null;
                if (!RAS.isEnabled(19, 26)) break;
                RAS.trace(19, 26, this, "getPcmciaImage()", "Unexpected Pcmcia type = " + string);
            }
        }
        if (string2 != null) {
            if (RAS.isEnabled(19, 26)) {
                RAS.trace(19, 26, this, "getPcmciaImage()", "Cookie! + " + string2);
            }
            widgetCookie = new WidgetCookie(string2, bundleName, modelInfo, cookiePath, this.pcmciaBladeModel, this.mssJdmBrowser, 16, "ibm.nways.mss.eui.PcmciaAdapterBladePanel");
            widgetCookie.setLocation(point);
            if (RAS.isEnabled(19, 26)) {
                RAS.trace(19, 26, this, "getPcmciaImage()", "Cookie OK!");
            }
        } else {
            widgetCookie = null;
        }
        return widgetCookie;
    }

    protected void setMssModel(GenModel genModel) {
        this.mssModel = genModel;
    }

    protected void setSSBlade(boolean bl) {
        this.ssBlade = bl;
    }

    public Point hdriveLocationInBlade(int n, boolean bl) {
        if (!bl) {
            if (n == 1) {
                return new Point(72, 74);
            }
            return new Point(72, 187);
        }
        return new Point(23, 72);
    }

    public Point pcmciaLocationInBlade(int n, boolean bl) {
        if (!bl) {
            if (n == 1) {
                return new Point(72, 74);
            }
            return new Point(72, 187);
        }
        if (n == 1) {
            return new Point(22, 72);
        }
        return new Point(33, 72);
    }
}

